/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/

//	GeometricalTolerance.cpp

#include <stdafx.h>

#include "CUtility.h"
#include "CDrawing.h"
#include "CApplication.h"


HRESULT GeometricalTolerance(IDesign *pDesign, IDrawingDocument *pDrawingDoc, IGraphic *pGraph1, IGeomTol **geometricaltol) 
{
	//	Creates a Geometrical Tolerance
	START_METHOD("GeometricalTolerance")

	HRESULT status = CONV_SUCCESS ;
	
	CHECK_VAR_STATUS(pDrawingDoc)

	IDrawingDocOthers *doc1 = CAST(IDrawingDocOthers, pDrawingDoc);

	IDrawingDocument *activeDoc = CAST(IDrawingDocument, pDrawingDoc);

	IGraphicDocument *activeGraphicDoc = CAST(IGraphicDocument, activeDoc);

	IDrawing *localDraw= NULL;
	status = activeDoc->GetDrawing(&localDraw) ;

	CHECK_RETURN_STATUS(status)

	IDesignDetail *pDetail = NULL;
	status = localDraw->GetDetail(pDesign, FALSE, &pDetail) ;
	CHECK_RETURN_STATUS(status)

	IGeometry *pGeom1 = NULL;
	status = activeDoc->GetPaperGeometry(pGraph1, &pGeom1) ;
	CHECK_RETURN_STATUS(status)

	IGeomTol *pTolerance = NULL;
	status = (GetCLASS(GeomTol))->CreateGeomTol(pDetail, pGeom1, &pTolerance) ;
	CHECK_RETURN_STATUS(status)

	*geometricaltol = pTolerance ;

	IGeomTolCallout *localGeomtolcallout = NULL;
	status = (GetCLASS(GeomTolCallout))->CreateGeomTolCallout(pTolerance, &localGeomtolcallout) ;
	CHECK_RETURN_STATUS(status)

	IGeomTol *newGeomTol = NULL;
	status = localGeomtolcallout->GetTolerance(&newGeomTol) ;
	CHECK_RETURN_STATUS(status)

	status = newGeomTol->SetTolerance(0.02) ;
	CHECK_RETURN_STATUS(status)

	status = newGeomTol->SetType(1);
	CHECK_RETURN_STATUS(status)

	status = newGeomTol->SetFeatureModifier(2);
	CHECK_RETURN_STATUS(status)

	IVector *pTextlocation = NULL;
	status = (GetCLASS(Vector))->CreateVector(0.1, 0.1, 0, &pTextlocation);
	CHECK_RETURN_STATUS(status)

	ICalloutGroup *localCalloutGroup = NULL;
	status = (GetCLASS(CalloutGroup))->CreateCalloutGroup(CAST(ICallout, localGeomtolcallout), pTextlocation, 0.005,&localCalloutGroup) ;
	CHECK_RETURN_STATUS(status)

	status = localCalloutGroup->SetControlPoint(1,pTextlocation) ;
	CHECK_RETURN_STATUS(status)

	short moved;
	status = localCalloutGroup->MoveCallout(CAST(ICallout, localGeomtolcallout), 1, TRUE, &moved);
	CHECK_RETURN_STATUS(status)

	// Get the active sheet in current drawing
	ISheet *pSheet = NULL;
	status = pDrawingDoc->GetActiveSheet(&pSheet);
	CHECK_RETURN_STATUS(status)

	status = pSheet->AddCalloutGroup(localCalloutGroup);
	CHECK_RETURN_STATUS(status)

	IFeatureLeader *pLeader = NULL;
	status = (GetCLASS(FeatureLeader))->CreateFeatureLeader(localCalloutGroup, pGeom1, &pLeader) ;
	CHECK_RETURN_STATUS(status)

	status = pSheet->AddLeader(CAST(ILeader, pLeader));
	CHECK_RETURN_STATUS(status)

	// Add center line
	// To be done

	END_METHOD("GeometricalTolerance")
}
